//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// LensflareActor, used to draw Lensflares
// ----------------------------------------------------------------------------
// Lensflares[5] 		-> 5 different lensflare textures can be set
// Distance 	 		-> the Distance until the lensflares fade out
// BlendScale    		-> intensity/speed of changing BlendFog
// bModulatedLensflares -> if true Lensflares are modulated RGB(127,127,127)
// bFilterLensflares    -> if true Lensflares are using Bilinear/Trilinear Filtering
// bSeperatedColors     -> if true all Lensflares can have different colors
// bBlendFX				-> enable/disable BlendFlashFog
// LFlare[8]			-> settings for 8 different single-Lensflare Presets
// MainLensColor		-> color for all Lensflares
// SingleLensColor[8]	-> colors for 8 different Lensflares
// bAfterUsage			-> destroys after usage if set on true
// bIgnoreActor 		-> if true trace goes through actor ignoring collision
// if false trace stops at any actor collision cylinder...
// ----------------------------------------------------------------------------
// Features:
// + renderes fully dynamic lensflares
// + center is the current Lensflare light
// + same preferences as coronas (is faded out when bsp is between player)
// + both Translucent and Modulated supported
// + no noticeable performance influences ;D
// + additional BlendEffect
// + uses ACanSeeB methode in XTMainUtil (tracing/lineofsight, fov, distance)
// Usage:
// 1. put this class in your map
// 2. setup the Lensflare Textures
// 3. setup texture style (Modulated or Translucent)
// 4. control that you have this enabled in your Menu
//=============================================================================
class LensflareActor expands XTEffectActors;

struct lensflare
{
	var() float UTile,VTile,UScale,VScale;
};

struct colorflare
{
	var color c,c2,c3,c4,c5;
};

var() texture Lensflares[5];		//5 different textures, but 8 different lensflares!
var() float Distance,BlendScale;
var() vector BlendFog;
var() bool bModulatedLensflares,bFilterLensflares,bSeperatedColors,bBlendFX,bIgnoreActors;
var() lensflare LFlare[8];
var() color MainLensColor,SingleLensColor[8];  //update (13.10.07) : now supports different single lens colors
var bool bAfterUsage;					//lensflares can only be seen with lens system, not with the pure eyes, thus
										//determine in which situation lensflares are caused
										//example: a cutscene is done and only in the cutscene lensflares "shall" be
										//visable, so set on true, to deactivate it for "pure eyes"

function FullSceneBlend()
{
	class'XTMainUtil'.static.fullsceneblend(false,self,blendfog,blendscale);
}
simulated event Tick(float t)
{
	local int i;
    if(class'xtmutator'.default.benablelensflares)
	{
		for(i=0;i<8;i++)
		{
			lensflares[i]=default.lensflares[i];
		}
		if (bBlendFX)fullsceneblend();
		if (bafterusage) destroy();
	}
	else	
	{
		for(i=0;i<8;i++)
		{
			lensflares[i]=none;
		}
	}
}

defaultproperties
{
     Distance=2000.000000
     bFilterLensflares=True
     LFlare(0)=(UTile=128.000000,VTile=128.000000,UScale=128.000000,VScale=128.000000)
     LFlare(1)=(UTile=128.000000,VTile=128.000000,UScale=64.000000,VScale=64.000000)
     LFlare(2)=(UTile=128.000000,VTile=128.000000,UScale=128.000000,VScale=128.000000)
     LFlare(3)=(UTile=128.000000,VTile=128.000000,UScale=64.000000,VScale=64.000000)
     LFlare(4)=(UTile=128.000000,VTile=128.000000,UScale=128.000000,VScale=128.000000)
     LFlare(5)=(UTile=128.000000,VTile=128.000000,UScale=128.000000,VScale=128.000000)
     LFlare(6)=(UTile=128.000000,VTile=128.000000,UScale=64.000000,VScale=64.000000)
     LFlare(7)=(UTile=128.000000,VTile=128.000000,UScale=180.000000,VScale=180.000000)
     Texture=Texture'UT99ExtensionPack.EdStuff.S_Lensflare'
     DrawScale=0.250000
     bGameRelevant=True
}
